// src/app/card/card.component.ts
import { Component, OnInit } from '@angular/core';
import { ArticleService } from '../article.service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { DatePipe } from '@angular/common';

@Component({
  selector: 'app-card',
  templateUrl: './card.component.html',
  styleUrls: ['./card.component.css'],
  providers: [DatePipe]
})
export class CardComponent implements OnInit {
  articles: any[] = [];
  articleDetail: any = null;

  constructor(private articleService: ArticleService, private sanitizer: DomSanitizer, private datePipe: DatePipe) { }

  ngOnInit(): void {
    this.articleService.getArticles().subscribe(data => {
      this.articles = data;
    });
  }

  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }

  showArticleDetail(contentId: string): void {
    this.articleService.getArticle(contentId).subscribe(data => {
      console.log("data", data);
      this.articleDetail = data;
    });
  }

  formatShortDate(date: string): string {
    return this.datePipe.transform(date, 'MM/dd/yyyy') || '';
  }

  goBack(): void {
    this.articleDetail = null;
  }
}